<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('city', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('area', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('country_language', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('country_language', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_intro', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('country_category', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('country_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_stores', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_stores', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store', function(Blueprint $table) {
			$table->foreign('country_category_id')->references('id')->on('country_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('store_menu_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('predefined_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupon')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('user_address_id')->references('id')->on('users_addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_review', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_review', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('store_menu_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('predefined_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupon')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_info', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('status_area', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('status_area', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_rate', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_rate', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_time_slots', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_time_slots', function(Blueprint $table) {
			$table->foreign('day_id')->references('id')->on('days')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifiction', function(Blueprint $table) {
			$table->foreign('notification_template_id')->references('id')->on('notifiction_template')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifiction', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_menu_category', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('store')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_menu_item', function(Blueprint $table) {
			$table->foreign('menu_category_id')->references('id')->on('store_menu_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_menu_subitems', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('predefined_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_menu_subitems', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('store_menu_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('city', function(Blueprint $table) {
			$table->dropForeign('city_country_id_foreign');
		});
		Schema::table('area', function(Blueprint $table) {
			$table->dropForeign('area_city_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_store_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_country_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_language_id_foreign');
		});
		Schema::table('country_language', function(Blueprint $table) {
			$table->dropForeign('country_language_country_id_foreign');
		});
		Schema::table('country_language', function(Blueprint $table) {
			$table->dropForeign('country_language_language_id_foreign');
		});
		Schema::table('app_intro', function(Blueprint $table) {
			$table->dropForeign('app_intro_country_id_foreign');
		});
		Schema::table('country_category', function(Blueprint $table) {
			$table->dropForeign('country_category_country_id_foreign');
		});
		Schema::table('country_category', function(Blueprint $table) {
			$table->dropForeign('country_category_category_id_foreign');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->dropForeign('users_addresses_user_id_foreign');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->dropForeign('users_addresses_area_id_foreign');
		});
		Schema::table('campaign_stores', function(Blueprint $table) {
			$table->dropForeign('campaign_stores_campaign_id_foreign');
		});
		Schema::table('campaign_stores', function(Blueprint $table) {
			$table->dropForeign('campaign_stores_store_id_foreign');
		});
		Schema::table('store', function(Blueprint $table) {
			$table->dropForeign('store_country_category_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_user_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_item_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_service_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_user_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_coupon_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_store_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_user_address_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_driver_id_foreign');
		});
		Schema::table('order_review', function(Blueprint $table) {
			$table->dropForeign('order_review_order_id_foreign');
		});
		Schema::table('order_review', function(Blueprint $table) {
			$table->dropForeign('order_review_user_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_item_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_service_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_coupon_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_order_id_foreign');
		});
		Schema::table('app_info', function(Blueprint $table) {
			$table->dropForeign('app_info_country_id_foreign');
		});
		Schema::table('status_area', function(Blueprint $table) {
			$table->dropForeign('status_area_store_id_foreign');
		});
		Schema::table('status_area', function(Blueprint $table) {
			$table->dropForeign('status_area_area_id_foreign');
		});
		Schema::table('store_rate', function(Blueprint $table) {
			$table->dropForeign('store_rate_user_id_foreign');
		});
		Schema::table('store_rate', function(Blueprint $table) {
			$table->dropForeign('store_rate_store_id_foreign');
		});
		Schema::table('store_time_slots', function(Blueprint $table) {
			$table->dropForeign('store_time_slots_store_id_foreign');
		});
		Schema::table('store_time_slots', function(Blueprint $table) {
			$table->dropForeign('store_time_slots_day_id_foreign');
		});
		Schema::table('notifiction', function(Blueprint $table) {
			$table->dropForeign('notifiction_notification_template_id_foreign');
		});
		Schema::table('notifiction', function(Blueprint $table) {
			$table->dropForeign('notifiction_user_id_foreign');
		});
		Schema::table('store_menu_category', function(Blueprint $table) {
			$table->dropForeign('store_menu_category_store_id_foreign');
		});
		Schema::table('store_menu_item', function(Blueprint $table) {
			$table->dropForeign('store_menu_item_menu_category_id_foreign');
		});
		Schema::table('store_menu_subitems', function(Blueprint $table) {
			$table->dropForeign('store_menu_subitems_service_id_foreign');
		});
		Schema::table('store_menu_subitems', function(Blueprint $table) {
			$table->dropForeign('store_menu_subitems_item_id_foreign');
		});
	}
}