<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('order_number', 'total_price', 'status', 'address', 'note', 'delivery_fee', 'grand_total', 'payment_method', 'user_id', 'restaurant_id');

	public function orderItems()
	{
		return $this->hasMany('App\Models\OrderItem');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function restaurant()
	{
		return $this->belongsTo('App\Models\Restaurant');
	}

	public function payment()
	{
		return $this->hasOne('App\Models\Payment');
	}

}