<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScriptsTable extends Migration {

	public function up()
	{
		Schema::create('scripts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('scripter_id')->unsigned();
			$table->boolean('paid');
			$table->boolean('visible');
			$table->boolean('premium');
			$table->string('city', 64);
			$table->string('title', 256);
			$table->string('version', 16);
			$table->text('description');
			$table->integer('level_knight')->unsigned()->default('0');
			$table->integer('level_paladin')->unsigned();
			$table->integer('level_sorcerer')->unsigned();
			$table->integer('level_druid')->unsigned();
			$table->integer('exph_min')->unsigned();
			$table->integer('exph_max')->unsigned();
			$table->integer('looth_min');
			$table->integer('looth_max');
			$table->integer('download_count')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('scripts');
	}
}