<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('plan_id')->unsigned()->nullable();
			$table->enum('type', array('client', 'company'))->nullable();
			$table->string('username')->nullable();
			$table->string('account_name')->nullable();
			$table->boolean('status')->nullable()->default(1);
			$table->string('email')->nullable();
			$table->string('phone')->unique();
			$table->float('wallet')->nullable();
			$table->string('hwia')->nullable();
			$table->string('sgl')->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('area_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}