<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countires')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('user_code', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('plan_options', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('plan_options', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('plan_options_all')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countires')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_working_days', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_followers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_followers', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_channels', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_channels', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_channel_followers_slides', function(Blueprint $table) {
			$table->foreign('slide_id')->references('id')->on('ads_followers_slides')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_channel_countries', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('user_channels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_channel_countries', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countires')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_channel_areas', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('user_channels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_channel_areas', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('user_channel_cities', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('user_channels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_channel_cities', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_employees', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_employees', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_employees_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_plan_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_country_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_area_id_foreign');
		});
		Schema::table('user_code', function(Blueprint $table) {
			$table->dropForeign('user_code_user_id_foreign');
		});
		Schema::table('plan_options', function(Blueprint $table) {
			$table->dropForeign('plan_options_plan_id_foreign');
		});
		Schema::table('plan_options', function(Blueprint $table) {
			$table->dropForeign('plan_options_option_id_foreign');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->dropForeign('areas_country_id_foreign');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->dropForeign('areas_area_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_area_id_foreign');
		});
		Schema::table('user_working_days', function(Blueprint $table) {
			$table->dropForeign('user_working_days_user_id_foreign');
		});
		Schema::table('user_followers', function(Blueprint $table) {
			$table->dropForeign('user_followers_user_id_foreign');
		});
		Schema::table('user_followers', function(Blueprint $table) {
			$table->dropForeign('user_followers_follower_id_foreign');
		});
		Schema::table('user_channels', function(Blueprint $table) {
			$table->dropForeign('user_channels_user_id_foreign');
		});
		Schema::table('user_channels', function(Blueprint $table) {
			$table->dropForeign('user_channels_channel_id_foreign');
		});
		Schema::table('user_channel_followers_slides', function(Blueprint $table) {
			$table->dropForeign('user_channel_followers_slides_slide_id_foreign');
		});
		Schema::table('user_channel_countries', function(Blueprint $table) {
			$table->dropForeign('user_channel_countries_channel_id_foreign');
		});
		Schema::table('user_channel_countries', function(Blueprint $table) {
			$table->dropForeign('user_channel_countries_country_id_foreign');
		});
		Schema::table('user_channel_areas', function(Blueprint $table) {
			$table->dropForeign('user_channel_areas_channel_id_foreign');
		});
		Schema::table('user_channel_areas', function(Blueprint $table) {
			$table->dropForeign('user_channel_areas_area_id_foreign');
		});
		Schema::table('user_channel_cities', function(Blueprint $table) {
			$table->dropForeign('user_channel_cities_channel_id_foreign');
		});
		Schema::table('user_channel_cities', function(Blueprint $table) {
			$table->dropForeign('user_channel_cities_city_id_foreign');
		});
		Schema::table('user_employees', function(Blueprint $table) {
			$table->dropForeign('user_employees_user_id_foreign');
		});
		Schema::table('user_employees', function(Blueprint $table) {
			$table->dropForeign('user_employees_employee_id_foreign');
		});
		Schema::table('user_employees_roles', function(Blueprint $table) {
			$table->dropForeign('user_employees_roles_user_id_foreign');
		});
	}
}