<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificacionesTable extends Migration {

	public function up()
	{
		Schema::create('notificaciones', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('identidad_id')->unsigned();
			$table->string('titulo', 255);
			$table->text('descripcion');
			$table->string('link', 255);
			$table->boolean('visto')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notificaciones');
	}
}