<?php

class Identidad extends Eloquent {

	protected $table = 'identidades';
	public $timestamps = true;
	protected $fillable = array('usuario_id');

	public function usuario()
	{
		return $this->belongsTo('Usuario');
	}

	public function mensajes_enviados()
	{
		return $this->hasMany('Mensaje', 'emisor_id');
	}

	public function mensajes_recibidos()
	{
		return $this->hasMany('Envio', 'receptor_id');
	}

	public function notificaciones()
	{
		return $this->hasMany('Notificacion');
	}

	public function alertas()
	{
		return $this->hasMany('Alerta');
	}

}