<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Etablissement extends Model 
{

    protected $table = 'etablissements';
    public $timestamps = true;
    protected $fillable = array('nom', 'etat', 'bp', 'slogan', 'email', 'telephone', 'annee_academique');
    protected $visible = array('nom', 'etat', 'bp', 'slogan', 'email', 'telephone', 'annee_academique');

    public function section()
    {
        return $this->hasMany('App\Section', 'id_etabissement');
    }

    public function categories_annee()
    {
        return $this->hasMany('App\Categorie_annee', 'id_etabissement');
    }

}