<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Serie extends Model 
{

    protected $table = 'series';
    public $timestamps = true;
    protected $fillable = array('id_sous_section', 'nom_serie', 'abreviation', 'etat', 'annee_academique');
    protected $visible = array('id_sous_section', 'nom_serie', 'abreviation', 'etat', 'annee_academique');

    public function serie_classe_mere()
    {
        return $this->hasMany('App\Serie_classe_mere', 'id_serie');
    }

    public function sous_section()
    {
        return $this->belongsTo('App\Section', 'id_section');
    }

    public function classe()
    {
        return $this->hasMany('App\Classe', 'id_serie');
    }

}