<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssetItemsTable extends Migration {

	public function up()
	{
		Schema::create('asset_items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->string('short_name', 20)->nullable();
			$table->integer('category_id')->unsigned();
			$table->integer('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('asset_items');
	}
}