<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->string('city', 50)->nullable();
			$table->increments('id');
			$table->string('name', 100);
			$table->string('legal_name', 30)->nullable();
			$table->string('agreement_no', 20)->nullable();
			$table->date('agreement_start_date')->nullable();
			$table->date('agreement_end_date')->nullable();
			$table->integer('status')->default('0');
			$table->text('address');
			$table->string('country', 50)->nullable();
			$table->string('state', 50)->nullable();
			$table->integer('zipcode')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}