<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PatientCase extends Model 
{

    protected $table = 'patient_cases';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('doctor_id', 'patient_id', 'title', 'details');

    public function patient()
    {
        return $this->belongsTo('Models\Patient', 'patient_id');
    }

    public function doctor()
    {
        return $this->belongsTo('Models\Doctor', 'doctor_id');
    }

}