<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PatientDocument extends Model 
{

    protected $table = 'patient_documents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('patient_id', 'title', 'attachment');

    public function patient()
    {
        return $this->belongsTo('Models\Patient', 'patient_id');
    }

}