<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class People extends Eloquent {

	protected $table = 'people';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('flat_id', 'type', 'name', 'surname', 'email', 'phone', 'is_resident');

	public function flat()
	{
		return $this->belongsTo('App\Models\Flat', 'id', 'flat_id');
	}

}