<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExchangeAccountsTable extends Migration {

	public function up()
	{
		Schema::create('exchange_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('account_id')->unsigned();
			$table->string('account_name')->nullable();
			$table->string('api_key');
			$table->string('api_secret');
			$table->string('exchange_id');
			$table->string('competition_count')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('exchange_accounts');
	}
}