<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWsCharitiesTable extends Migration {

	public function up()
	{
		Schema::create('ws_charities', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('uid');
			$table->string('name', 255);
			$table->text('description');
			$table->string('url', 255);
			$table->string('logo', 255);
			$table->float('income')->default('0.5');
			$table->text('widgets');
			$table->tinyInteger('listed')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('ws_charities');
	}
}