<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('email')->unique();
			$table->string('password');
			$table->string('phone')->unique();
			$table->bigInteger('photoalbum_image_id')->unsigned();
			$table->bigInteger('contact_id')->default('0');
			$table->text('description');
			$table->text('awards');
			$table->tinyInteger('is_public')->index()->default('0');
			$table->tinyInteger('is_inactive')->index()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}