<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->integer('avatar_id');
			$table->string('titel', 255);
			$table->string('slug');
			$table->string('subtitle', 255);
			$table->string('href', 255);
			$table->tinyInteger('order');
			$table->text('custom');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}