<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function details()
	{
		return $this->hasMany('UserDetail');
	}

	public function throttles()
	{
		return $this->hasMany('Throttle');
	}

	public function groups()
	{
		return $this->belongsToMany('Group', 'users_groups');
	}

	public function achievements()
	{
		return $this->belongsToMany('Achievement', 'user_achievements');
	}

	public function school()
	{
		return $this->belongsTo('School');
	}

	public function progress()
	{
		return $this->hasMany('UserProgress');
	}

}