<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionnairesTable extends Migration {

	public function up()
	{
		Schema::create('questionnaires', function(Blueprint $table) {
			$table->increments('id');
			$table->string('question_en', 1000);
			$table->string('question_bn', 1000);
			$table->enum('choice_type', array('radio-button', 'checkbox', 'input', '1to5', '1to10'));
			$table->json('choices')->default('[]');
			$table->integer('order');
			$table->binary('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('questionnaires');
	}
}