<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTriggersTable extends Migration {

	public function up()
	{
		Schema::create('triggers', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('nps', 'ces', 'csat'))->index();
			$table->string('event', 250);
			$table->enum('category', array('transactional', 'non_transactional'));
			$table->string('description', 500)->nullable();
			$table->integer('channel_id')->unsigned();
			$table->integer('questionnaire_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('triggers');
	}
}