<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->char('customer_type', 2);
			$table->string('name', 45);
			$table->string('nickname', 45)->nullable();
			$table->string('email')->unique();
			$table->string('password', 50);
			$table->string('cpf_cnpj', 14);
			$table->string('rg_ie', 13);
			$table->string('phone', 15);
			$table->tinyInteger('active');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}