<?php

class DeliveryAddress extends Eloquent {

	protected $table = 'delivery_addresses';
	public $timestamps = true;
	protected $fillable = array('customer_id', 'zipcode', 'street', 'number', 'district', 'city', 'state');
	protected $visible = array('customer_id', 'zipcode', 'street', 'number', 'district', 'city', 'state');

	public function order()
	{
		return $this->hasOne('Order');
	}

	public function customer()
	{
		return $this->belongsTo('Customer');
	}

}