<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateViolationsTable extends Migration {

	public function up()
	{
		Schema::create('violations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('manager_id')->unsigned();
			$table->bigInteger('player_id')->unsigned();
			$table->integer('type')->unsigned()->index()->default('0');
			$table->text('description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('violations');
	}
}