<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediaTable extends Migration {

	public function up()
	{
		Schema::create('media', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('entity_id');
			$table->string('entity_type');
			$table->string('name')->nullable();
			$table->string('path');
			$table->string('extension')->nullable();
			$table->enum('locale', array('en', 'ar'));
			$table->enum('type', array('bg_img', 'file', 'cover'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('media');
	}
}