<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediaTable extends Migration {

	public function up()
	{
		Schema::create('media', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 50);
			$table->string('file_name', 200);
			$table->string('extension', 10);
			$table->enum('type', array('video', 'audio', 'image'));
		});
	}

	public function down()
	{
		Schema::drop('media');
	}
}