<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogCommentsTable extends Migration {

	public function up()
	{
		Schema::create('blog_comments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('blog_post_id')->unsigned();
			$table->enum('status', array('pending', 'accepted', 'rejected'));
			$table->string('ip', 25)->nullable();
			$table->string('user_agent', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('blog_comments');
	}
}