<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormTable extends Migration {

	public function up()
	{
		Schema::create('form', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('application_id')->unsigned();
			$table->string('name', 255);
			$table->text('description');
			$table->string('end_note', 255);
			$table->enum('type', array('stepper', 'page'));
			$table->enum('theme', array('onemtwo'));
			$table->string('search_page');
			$table->enum('contact_form', array('one', 'two'));
			$table->binary('is_active');
			$table->binary('is_start_screen');
			$table->binary('is_end_screen');
			$table->binary('is_allowed_multiple_subs');
			$table->binary('is_progress_indicator');
			$table->binary('is_search_result');
			$table->datetime('expiry_date');
			$table->string('form_url', 255);
			$table->string('background_image', 255);
			$table->string('background_color', 255);
			$table->string('text_color', 255);
			$table->string('option_color', 255);
			$table->string('option_text_color');
			$table->string('button_color', 255);
			$table->string('bunner_text_color', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('form');
	}
}