<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormQuestionTable extends Migration {

	public function up()
	{
		Schema::create('form_question', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('form_id')->unsigned();
			$table->enum('type', array('NumberShortTextLongTextRadiobuttonsCheckboxesEmailURLDateOpinionScaleRatingUploadFile'));
			$table->string('question', 255);
			$table->string('help_Text', 255);
			$table->binary('is_required');
			$table->binary('has_other_field');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('form_question');
	}
}