<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Producto extends Eloquent {

	protected $table = 'productos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nombre', 'stock', 'precio');

	public function categoria()
	{
		return $this->belongsTo('Categoria', 'categoria_id');
	}

	public function compras()
	{
		return $this->belongsToMany('Compra', 'producto_compra');
	}

}