<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblKiloshareTransTable extends Migration {

	public function up()
	{
		Schema::create('tbl_kiloshare_trans', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('trip_id')->unsigned();
			$table->integer('guest_id')->unsigned();
			$table->integer('owner_id')->unsigned();
			$table->date('date');
			$table->bigInteger('kilo_share');
			$table->enum('guest_status', array('true', 'false'));
			$table->enum('owner_status', array('true', 'false'));
			$table->enum('main_status', array('waiting', 'done', 'different'));
		});
	}

	public function down()
	{
		Schema::drop('tbl_kiloshare_trans');
	}
}