<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBuyerTable extends Migration {

	public function up()
	{
		Schema::create('buyer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->string('password');
			$table->enum('is_active', array(''));
			$table->string('state');
			$table->string('district');
			$table->string('place');
			$table->integer('pincode');
			$table->string('whatsapp');
			$table->string('gst');
			$table->string('pancard');
		});
	}

	public function down()
	{
		Schema::drop('buyer');
	}
}