<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTable extends Migration {

	public function up()
	{
		Schema::create('category', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('is_active');
			$table->increments('order');
			$table->integer('menu_id')->unsigned();
			$table->string('img');
			$table->integer('top_collection_status');
			$table->string('meta_title');
			$table->string('meta_desc');
			$table->string('meta_keyword');
		});
	}

	public function down()
	{
		Schema::drop('category');
	}
}