<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class League extends Eloquent {

	protected $table = 'leagues';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function teams_leagues_id()
	{
		return $this->hasMany('Team', 'league_id');
	}

	public function matches_league_id()
	{
		return $this->hasMany('Match', 'league_id');
	}

}