<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('request', function(Blueprint $table) {
			$table->foreign('client_id')->references('client_id')->on('request')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->foreign('service_id')->references('service_id')->on('request')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->foreign('engineer_id')->references('engineer_id')->on('request')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->foreign('request_id')->references('request_id')->on('request')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('representative', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('representative')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('representative', function(Blueprint $table) {
			$table->foreign('represents')->references('represents')->on('representative')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->foreign('client_id')->references('client_id')->on('contract')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('contractmap', function(Blueprint $table) {
			$table->foreign('contract_id')->references('contract_id')->on('contractmap')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('contractmap', function(Blueprint $table) {
			$table->foreign('service_id')->references('service_id')->on('contractmap')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('request_id')->references('request_id')->on('log')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('administrator_id')->references('administrator_id')->on('log')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('engineer_id')->references('engineer_id')->on('log')
						->onDelete('set null')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('request', function(Blueprint $table) {
			$table->dropForeign('request_client_id_foreign');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->dropForeign('request_service_id_foreign');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->dropForeign('request_engineer_id_foreign');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->dropForeign('request_request_id_foreign');
		});
		Schema::table('representative', function(Blueprint $table) {
			$table->dropForeign('representative_user_id_foreign');
		});
		Schema::table('representative', function(Blueprint $table) {
			$table->dropForeign('representative_represents_foreign');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->dropForeign('contract_client_id_foreign');
		});
		Schema::table('contractmap', function(Blueprint $table) {
			$table->dropForeign('contractmap_contract_id_foreign');
		});
		Schema::table('contractmap', function(Blueprint $table) {
			$table->dropForeign('contractmap_service_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_request_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_administrator_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_engineer_id_foreign');
		});
	}
}