<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pages_history', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('menus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('actualities', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('actualities', function(Blueprint $table) {
			$table->foreign('upated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('actualities_history', function(Blueprint $table) {
			$table->foreign('actuality_id')->references('id')->on('actualities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_created_by_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_updated_by_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_user_id_foreign');
		});
		Schema::table('pages_history', function(Blueprint $table) {
			$table->dropForeign('pages_history_page_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_created_by_foreign');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->dropForeign('menus_parent_id_foreign');
		});
		Schema::table('actualities', function(Blueprint $table) {
			$table->dropForeign('actualities_created_by_foreign');
		});
		Schema::table('actualities', function(Blueprint $table) {
			$table->dropForeign('actualities_upated_by_foreign');
		});
		Schema::table('actualities_history', function(Blueprint $table) {
			$table->dropForeign('actualities_history_actuality_id_foreign');
		});
	}
}