<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediasTable extends Migration {

	public function up()
	{
		Schema::create('medias', function(Blueprint $table) {
			$table->increments('id');
			$table->string('file_name', 80);
			$table->string('mime_type', 50);
			$table->integer('file_weight');
			$table->integer('picture_width')->nullable();
			$table->integer('picture_height')->nullable();
			$table->timestamp('created_at');
			$table->integer('created_by')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('medias');
	}
}