<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('type_search')->nullable();
			$table->integer('type_person')->nullable();
			$table->integer('civility');
			$table->string('firstname', 100)->nullable();
			$table->string('lastname', 100)->nullable();
			$table->string('email', 255);
			$table->string('society', 255)->nullable();
			$table->string('phone', 100)->nullable();
			$table->text('content');
			$table->boolean('seen')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}