<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('transcriptions', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('application')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('transcriptions', function(Blueprint $table) {
			$table->foreign('transcribed_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transcriptions', function(Blueprint $table) {
			$table->foreign('qa_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transcriptions', function(Blueprint $table) {
			$table->foreign('locked_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('application', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('queues', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('field', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('application')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('field_values', function(Blueprint $table) {
			$table->foreign('transcription_id')->references('id')->on('transcriptions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('field_values', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('field')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('escalations', function(Blueprint $table) {
			$table->foreign('transcription_id')->references('id')->on('transcriptions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('extracts', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_history', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('audit_result', function(Blueprint $table) {
			$table->foreign('transcription_id')->references('id')->on('transcriptions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recordings', function(Blueprint $table) {
			$table->foreign('transcription_id')->references('id')->on('transcriptions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recordings', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('field')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('transcriptions', function(Blueprint $table) {
			$table->dropForeign('transcriptions_application_id_foreign');
		});
		Schema::table('transcriptions', function(Blueprint $table) {
			$table->dropForeign('transcriptions_transcribed_user_id_foreign');
		});
		Schema::table('transcriptions', function(Blueprint $table) {
			$table->dropForeign('transcriptions_qa_user_id_foreign');
		});
		Schema::table('transcriptions', function(Blueprint $table) {
			$table->dropForeign('transcriptions_locked_by_foreign');
		});
		Schema::table('application', function(Blueprint $table) {
			$table->dropForeign('application_client_id_foreign');
		});
		Schema::table('queues', function(Blueprint $table) {
			$table->dropForeign('queues_client_id_foreign');
		});
		Schema::table('field', function(Blueprint $table) {
			$table->dropForeign('field_application_id_foreign');
		});
		Schema::table('field_values', function(Blueprint $table) {
			$table->dropForeign('field_values_transcription_id_foreign');
		});
		Schema::table('field_values', function(Blueprint $table) {
			$table->dropForeign('field_values_field_id_foreign');
		});
		Schema::table('escalations', function(Blueprint $table) {
			$table->dropForeign('escalations_transcription_id_foreign');
		});
		Schema::table('extracts', function(Blueprint $table) {
			$table->dropForeign('extracts_client_id_foreign');
		});
		Schema::table('user_history', function(Blueprint $table) {
			$table->dropForeign('user_history_user_id_foreign');
		});
		Schema::table('audit_result', function(Blueprint $table) {
			$table->dropForeign('audit_result_transcription_id_foreign');
		});
		Schema::table('recordings', function(Blueprint $table) {
			$table->dropForeign('recordings_transcription_id_foreign');
		});
		Schema::table('recordings', function(Blueprint $table) {
			$table->dropForeign('recordings_field_id_foreign');
		});
	}
}