<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFinishCalcsTable extends Migration {

	public function up()
	{
		Schema::create('finish_calcs', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('execuation_duration_id')->unsigned();
			$table->bigInteger('finish_item_id')->unsigned();
			$table->decimal('unit_height', 8,2);
			$table->decimal('unit_area', 8,2);
			$table->tinyInteger('rooms_num');
			$table->decimal('rooms_area', 8,2);
			$table->tinyInteger('kitchens_num');
			$table->decimal('kitchens_area', 8,2);
			$table->tinyInteger('bathroom_num');
			$table->decimal('bathrooms_area', 8,2);
			$table->decimal('remeaning_area', 8,2);
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
			$table->bigInteger('finish_level_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('finish_calcs');
	}
}