<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id_customer')->unsigned();
			$table->bigInteger('user_id_indep_pro')->unsigned();
			$table->bigInteger('user_id_shop')->unsigned();
			$table->bigInteger('user_id_dep_pro')->unsigned();
			$table->bigInteger('charges');
			$table->time('total_time');
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}