<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function independentProfessionals()
	{
		return $this->hasMany('IndependentProfessionals', 'user_id', 'id');
	}

	public function shopOwners()
	{
		return $this->hasMany('ShopOwner', 'user_id', 'id');
	}

	public function userServices()
	{
		return $this->hasMany('ServiceBook', 'user_id', 'id');
	}

	public function independentProReviews()
	{
		return $this->hasMany('Review', 'user_id', 'id');
	}

	public function dependentProReviews()
	{
		return $this->hasMany('Review', 'user_id', 'id');
	}

	public function customerAppointments()
	{
		return $this->hasMany('Appointment', 'user_id_customer', 'id');
	}

	public function independentProAppointments()
	{
		return $this->belongsTo('Appointment', 'user_id_indep_pro', 'id');
	}

	public function shopAppointments()
	{
		return $this->hasMany('Appointment', 'user_id_shop', 'id');
	}

	public function dependentProAppointments()
	{
		return $this->hasMany('Appointment', 'user_id_dep_pro', 'id');
	}

	public function shopOwnerStore()
	{
		return $this->hasOne('EStore', 'user_id', 'id');
	}

	public function indepProStore()
	{
		return $this->hasOne('EStore', 'user_id', 'id');
	}

}