<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyProfilesTable extends Migration {

	public function up()
	{
		Schema::create('company_profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('company_id')->unsigned()->index();
			$table->string('company_address', 256)->nullable();
			$table->string('company_address_2', 256)->nullable();
			$table->integer('company_city_id')->unsigned()->index();
			$table->char('company_state', 2)->index();
			$table->enum('company_number_employees', array('Under10', '11-50', '51-150', 'Over150'))->index();
			$table->string('company_fein', 50)->nullable();
			$table->string('company_crs', 50)->index();
			$table->string('company_ean', 50);
		});
	}

	public function down()
	{
		Schema::drop('company_profiles');
	}
}