<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('mobile_no', 15);
			$table->string('address')->nullable();
			$table->bigInteger('created_by')->unsigned();
			$table->string('created_by_ip', 15);
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->string('updated_by_ip', 15)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}