<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInRequestsTable extends Migration {

	public function up()
	{
		Schema::create('in_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('nokia_requester_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->integer('stream_id')->unsigned();
			$table->text('notes');
			$table->integer('site_id')->unsigned();
			$table->integer('subcontractor_id')->unsigned()->nullable();
			$table->integer('internal_supplier_id')->unsigned()->nullable();
			$table->integer('entity_id')->unsigned();
			$table->string('work_order_id');
			$table->bigInteger('delivery_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('in_requests');
	}
}