<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDprdSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('dprd_schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('bm_id')->unsigned()->nullable()->index();
			$table->date('date_schedule')->index();
			$table->time('time_schedule')->index();
			$table->string('place', 191)->index();
			$table->text('agenda');
			$table->string('note', 191);
		});
	}

	public function down()
	{
		Schema::drop('dprd_schedules');
	}
}