<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 250);
			$table->enum('category', array('seed', 'fertilizer', 'land'));
			$table->tinyInteger('being_funded');
			$table->integer('avl_shares');
			$table->integer('total_shares');
			$table->float('bid_price', 8,4);
			$table->integer('avl_units');
			$table->float('total_cost', 8,4);
			$table->float('unit_price', 8,4);
			$table->integer('ET');
			$table->integer('FT');
			$table->integer('quality');
			$table->string('description', 250);
			$table->bigInteger('launched_at');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}