<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnexoTable extends Migration {

	public function up()
	{
		Schema::create('anexo', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->integer('concesion_id')->nullable()->index();
			$table->integer('anexo_conagua_id')->nullable()->index();
			$table->string('numeroanexo', 8)->nullable();
			$table->string('driveid', 45)->nullable();
			$table->string('cp', 5)->nullable();
			$table->string('estado', 100)->nullable();
			$table->string('municipio', 100)->nullable();
			$table->string('localidad', 100)->nullable();
			$table->string('latlngtitulo', 100)->nullable();
			$table->string('latlngconfirmada', 100)->nullable();
			$table->string('tipo', 45)->nullable();
			$table->string('usoinicial', 45)->nullable();
			$table->double('volumenextraccionautorizado', 10,2)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('anexo');
	}
}