<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonaTable extends Migration {

	public function up()
	{
		Schema::create('persona', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->integer('user_id')->index();
			$table->string('tipopersona', 1)->nullable()->default('F');
			$table->string('titulo', 45)->nullable();
			$table->string('nombre', 200)->nullable();
			$table->string('paterno', 200)->nullable();
			$table->string('materno', 200)->nullable();
			$table->string('fotografia', 255)->nullable();
			$table->string('curp', 19)->nullable();
			$table->string('rfc', 13)->nullable();
			$table->string('actividadpreponderante', 100)->nullable();
			$table->string('driveid', 45)->nullable();
			$table->string('cp', 5)->nullable();
			$table->string('estado', 100)->nullable();
			$table->string('municipio', 100)->nullable();
			$table->string('localidad', 100)->nullable();
			$table->string('tipodomicilio', 100)->nullable();
			$table->string('tipovialidad', 100)->nullable();
			$table->string('nombrevialidad', 100)->nullable();
			$table->string('tipoasentamiento', 100)->nullable();
			$table->string('nombreasentamiento', 100)->nullable();
			$table->string('numext', 10)->nullable();
			$table->string('numint', 10)->nullable();
			$table->integer('idrepresentante');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('persona');
	}
}