<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function persona()
    {
        return $this->hasOne('Persona');
    }

    public function concesiones()
    {
        return $this->belongsTo('Concesion');
    }

    public function tramites()
    {
        return $this->belongsTo('Tramite');
    }

    public function suscripciones()
    {
        return $this->belongsTo('Suscripcion');
    }

    public function pagos()
    {
        return $this->belongsTo('Pago');
    }

    public function misconcesiones()
    {
        return $this->hasManyThrough('Concesion', 'ConcesionConcesionario');
    }

}